#version 420 compatibility

#define FoliageMovement 0.1 //[0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.2 0.3 0.4 0.5]

uniform float rainStrength;
uniform float frameTimeCounter;

uniform vec3 cameraPosition;

uniform mat4 shadowModelViewInverse;

uniform vec3 sunPosition;

attribute vec4 mc_Entity;

varying vec4 texcoord;
varying vec4 color;

varying vec3 normal;
varying vec3 shadowviewpos;
varying vec3 shadowworldpos;
varying vec3 binormal;
varying vec3 tangent;

#define SHADOW_MAP_BIAS 0.85

//float bias = SHADOW_MAP_BIAS - clamp(dot(normalize(sunPosition), normal),0.0,1.0);

vec2 getMultipliedShadowPos(in vec2 pos) {
    return pos*abs(pos)*1.357225;
}

void main() {
    vec4 pos = gl_Vertex;
	
    float fast =  (FoliageMovement/4.);
    float fastsinx = sin((frameTimeCounter*1.0) + (cameraPosition.y+pos.y));
    float fastsiny = sin((frameTimeCounter*1.0) + (cameraPosition.z+pos.z));
    float fastsinz = sin((frameTimeCounter*1.0) + (cameraPosition.x+pos.x));

    float medium = (FoliageMovement/2.);
    float mediumsinx = sin((frameTimeCounter*0.5) + (cameraPosition.y+pos.y)+0.12);
    float mediumsiny = sin((frameTimeCounter*0.5) + (cameraPosition.z+pos.z)+0.12);
    float mediumsinz = sin((frameTimeCounter*0.5) + (cameraPosition.x+pos.x)+0.12);

    float slow = FoliageMovement;
    float slowsinx = sin((frameTimeCounter*0.25) + (cameraPosition.y+pos.y)+0.01);
    float slowsiny = sin((frameTimeCounter*0.25) + (cameraPosition.z+pos.z)+0.01);
    float slowsinz = sin((frameTimeCounter*0.25) + (cameraPosition.x+pos.x)+0.01);

	if(mc_Entity.x == 161.0 || mc_Entity.x == 18.0 || mc_Entity.x == 175.0 || mc_Entity.x == 32.0 || mc_Entity.x == 31.0 || mc_Entity.x == 8.0 || mc_Entity.x == 9.0) {
		pos.x += (fast*fastsinx)+(medium*mediumsinx)+(slow*slowsinx);
		pos.y += (fast*fastsiny)+(medium*mediumsiny)+(slow*slowsiny);
		pos.z += (fast*fastsinz)+(medium*mediumsinz)+(slow*slowsinz);

	}

	tangent = vec3(0.0);
	binormal = vec3(0.0);

	if (gl_Normal.x > 0.5) {
		//  1.0,  0.0,  0.0
		tangent  = normalize(gl_NormalMatrix * vec3( 0.0,  0.0, -1.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	}
	
	else if (gl_Normal.x < -0.5) {
		// -1.0,  0.0,  0.0
		tangent  = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	}
	
	else if (gl_Normal.y > 0.5) {
		//  0.0,  1.0,  0.0
		tangent  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
	}
	
	else if (gl_Normal.y < -0.5) {
		//  0.0, -1.0,  0.0
		tangent  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
	}
	
	else if (gl_Normal.z > 0.5) {
		//  0.0,  0.0,  1.0
		tangent  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	}
	
	else if (gl_Normal.z < -0.5) {
		//  0.0,  0.0, -1.0
		tangent  = normalize(gl_NormalMatrix * vec3(-1.0,  0.0,  0.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	}

    gl_Position = gl_ProjectionMatrix * (gl_ModelViewMatrix * pos);
    vec2 multipliedShadowPos = getMultipliedShadowPos(gl_Position.xy);
    float dist = pow(multipliedShadowPos.x*multipliedShadowPos.x + multipliedShadowPos.y*multipliedShadowPos.y, 1.0/4.0);
    float distFac = (1.0 - SHADOW_MAP_BIAS) + dist * SHADOW_MAP_BIAS;
    gl_Position.xy /= distFac*0.92;
    gl_Position.z = gl_Position.z * 0.2;
	//gl_Position.xyz += cameraPosition;
    texcoord = gl_MultiTexCoord0;
    color = gl_Color;
    normal = normalize(gl_NormalMatrix*gl_Normal);
    shadowviewpos = (gl_ModelViewMatrix * gl_Vertex).xyz;
    shadowworldpos = mat3(shadowModelViewInverse)*shadowviewpos+shadowModelViewInverse[3].xyz+cameraPosition;
}