#version 120

#include "lib/defines.glsl"

uniform float frameTimeCounter;
uniform float inSoulSandValley;
uniform sampler2D noisetex;
uniform sampler2D texture;

varying float ao;
varying float isLava;
varying vec2 lmcoord;
varying vec2 randCoord;
varying vec2 texcoord;
varying vec4 tint;

#include "/lib/noiseres.glsl"

#ifdef LAVA_PATCHES
	float noiseMap(vec2 coord) {
		coord *= invNoiseRes;
		float noise = 0.0;
		noise += texture2D(noisetex, coord * 0.03125).r;
		noise += texture2D(noisetex, coord * 0.09375).r * 0.5;
		noise += texture2D(noisetex, coord * 0.375  ).r * 0.25;
		return noise;
	}
#endif

void main() {
	vec4 color = texture2D(texture, texcoord) * tint;
	#ifdef GRASS_AO
		if (ao < 0.999) color.rgb *= sqrt(ao) * 0.5 + 0.5;
	#endif

	if (isLava > 0.9) {
		#ifdef LAVA_PATCHES
			if (color.r > 0.625) { //ignore non-lava part of magma blocks
				color.rgb += cos(
					noiseMap(randCoord) * 12.5
					+ frameTimeCounter * 0.5
				)
				* 0.125;
			}
		#endif
		#ifdef SOUL_LAVA
			color.rb = mix(color.rb, color.br, inSoulSandValley);
		#endif
	}

/* DRAWBUFFERS:04 */
	gl_FragData[0] = color; //gcolor
	gl_FragData[1] = vec4(lmcoord, 1.0, 1.0); //gaux1
}